/**
 * Tiny slider widget
 * Copyright (c) 2022 Gian MR
 * Gian MR Theme Custom Javascript
 *
 * @package newkarma
 */	
(function( slider ){
	"use strict";
  
	document.addEventListener( 'DOMContentLoaded', function() {

		var sl = document.querySelectorAll( '.gmr-class-widgetslider' );

		sl.forEach( function( s ) {
			if ( s ) {
				var token = s.dataset.token;
				var z = window['gmrobjslide' + token];
				var slider = tns({
					container: z.wgtclass,
					loop: false,
					gutter: 0,
					edgePadding: 0,
					items: 1,
					swipeAngle: false,
					mouseDrag: true,
					nav: true,
					controls: false,
					autoplay: true,
					autoplayButtonOutput: false,
					responsive : {
						0 : {
							items : 1,
						},
						250 : {
							items : 1,
						},
						400 : {
							items : 1,
						},
						600 : {
							items : 1,
						},
						1000 : {
							items : 1,
						}
					}
				});
			}
		});
    });
})( window.slider );
