/**
 * Copyright (c) 2021 Gian MR
 * Gian MR Theme Custom Javascript
 *
 * @package Newkarma
 */

(function(sidr) {
	"use strict";

	sidr.new('#gmr-topnavresponsive-menu', {
		name: 'topnavmenus',
		source: '.gmr-mobilelogo, .close-topnavmenu-wrap, .gmr-mainmenu, .gmr-secondmenuwrap',
		displace: false,
		onOpen   : function( name ) {
			// Re-name font Icons to correct classnames and support menu icon plugins.
			var elems = document.querySelectorAll( "[class*='sidr-class-icon_'], [class*='sidr-class-_mi']" ), i;
			for ( i = 0; i < elems.length; i++ ) {
				var elm = elems[i];
				if ( elm.className ) {
					elm.className = elm.className.replace(/sidr-class-/g,'');
				}
			}
		}
	});

	var sidrclose = document.querySelector( '#sidr-id-close-topnavmenu-button' );
	
	if ( sidrclose !== null ) {
		sidrclose.addEventListener(
			'click',
			function( e ) {
				e.preventDefault();
				sidr.close('topnavmenus');
			}
		);
	}

	var srch = document.querySelector( 'input#sidr-id-s' );
	if ( srch !== null ) {
		srch.addEventListener(
			'click',
			function( e ) {
				e.preventDefault();
				e.stopPropagation();
			}
		);
	}
	
	/* $( '.sidr-inner li' ).each( */
	var elmTag = document.querySelectorAll( '.sidr-inner li' ), i;
	
	for ( i = 0; i < elmTag.length; i++ ) {
		if ( elmTag[i].querySelectorAll( 'ul' ).length > 0 ) {
			var elm = elmTag[i].querySelectorAll( 'a' );
			if ( elm !== null ) {
				elm[0].innerHTML += '<span class="sub-toggle"><span class="gmr-icon-down"></span></span>';
			}
		}
	}
	
	/* $( '.sidr-inner .sub-toggle' ).click( */
	var elmTag = document.querySelectorAll( '.sidr-inner .sub-toggle' ), i;
	
	for ( i = 0; i < elmTag.length; i++ ) {
		elmTag[i].addEventListener(
			'click',
			function( e ) {
				e.preventDefault();
				var t = this;
				t.classList.toggle( 'is-open' );
				if ( t.classList.contains( 'is-open' ) ) {
					var txt = '<span class="gmr-icon-up"></span>';
				} else {
					var txt = '<span class="gmr-icon-down"></span>';
				}
				t.innerHTML = txt;
				/* console.log (t.parentNode.parentNode.querySelectorAll( 'a' )[0].nextElementSibling); */
				var container = t.parentNode.parentNode.querySelectorAll( 'a' )[0].nextElementSibling;
				if ( !container.classList.contains( 'active' ) ) {
					container.classList.add('active');
				} else {
					container.classList.remove('active');
				}
			}
		);
	}

})( window.sidr );

/* Click Dropdown Search */
(function(){
	"use strict";

	var btn = document.getElementById( 'search-menu-button' );

	// Close the dropdown menu if the user clicks outside of it.
	if ( btn ) {
		btn.addEventListener(
			'click',
			function( e ) {
				e.stopPropagation();
				e.preventDefault();
				var dropdowns = document.querySelector( '.search-dropdown' );
				dropdowns.classList.toggle( 'active' );
				if ( dropdowns.classList.contains( 'active' ) ) {
					btn.classList.add( 'toggled-on' );
				} else {
					btn.classList.remove( 'toggled-on' );
				}
				var getid = document.getElementById( 'search-dropdown-container' );
				document.addEventListener(
					'click',
					function( e ) {
						if ( getid !== e.target && ! getid.contains( e.target ) ) {
							if ( dropdowns.classList.contains( 'active' ) ) {
								dropdowns.classList.remove( 'active' );
								btn.classList.remove( 'toggled-on' );
							}
						}
					}
				);
			}
		);
	}

})();

/* Date, for non minify see in wpmedia theme non productions */
const idthemeloadDate=()=>{let e=document.querySelector(".gmr-top-date");if(null!==e){let t=Date.now();if(null!==e){let n=e.getAttribute("data-lang"),l=n||"en-US";if(null!==t){let a={weekday:"long",day:"numeric",month:"long",year:"numeric"},o=new Intl.DateTimeFormat(l,a).format(t);null!==o&&(e.innerHTML=o)}}}};window.addEventListener("DOMContentLoaded",function(){setTimeout(()=>{idthemeloadDate()},150)});

( function() {
	"use strict";
	
	window.addEventListener(
	'scroll',
	function() {
		var elmontop = document.querySelector( '.gmr-ontop' );
		if ( document.body.scrollTop > 85 || document.documentElement.scrollTop > 85 ) {
			if ( elmontop !== null ) {
				elmontop.style.display = 'block';
				document.querySelector( '.gmr-ontop' ).addEventListener(
					'click',
					function( e ) {
						e.preventDefault();
						window.scroll({top: 0, left: 0, behavior: 'smooth'});
					}
				);
			}
		} else {
			if ( elmontop !== null ) {
				elmontop.style.display = 'none';
			}
		}

	});
})();
