<?php
/**
 * Custom homepage category content.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Newkarma
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'newkarma_display_carousel' ) ) :
	/**
	 * This function for display slider in homepage
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	function newkarma_display_carousel() {
		global $post;
		$post_num = get_theme_mod( 'gmr_headline_number', '5' );
		$cat      = get_theme_mod( 'gmr_category-headline', 0 );

		$args = array(
			'post_type'              => 'post',
			'cat'                    => $cat,
			'orderby'                => 'date',
			'order'                  => 'desc',
			'showposts'              => $post_num,
			'post_status'            => 'publish',
			'ignore_sticky_posts'    => 1,
			// make it fast withour update term cache and cache results
			// https://thomasgriffin.io/optimize-wordpress-queries/.
			'update_post_term_cache' => false,
			'update_post_meta_cache' => false,
			'no_found_rows'          => true,
		);

		$recent = get_posts( $args );
		echo '<div id="moduleslide" class="clearfix gmr-element-carousel">';
			echo '<div class="gmr-owl-wrap">';
			echo '<div class="gmr-owl-carousel owl-carousel owl-theme">';
		foreach ( $recent as $post ) :
			setup_postdata( $post );
			?>
				<div class="item gmr-slider-content">
				<?php
				$featured_image_url = wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) );
				if ( ! empty( $featured_image_url ) ) {
					?>
						<div class="other-content-thumbnail">
							<?php
							echo '<a href="' . esc_url( get_permalink() ) . '" itemprop="url" title="' . the_title_attribute(
								array(
									'before' => __( 'Permalink to: ', 'newkarma' ),
									'after'  => '',
									'echo'   => false,
								)
							) . '" rel="bookmark">';
							if ( has_post_thumbnail() ) :
								the_post_thumbnail( 'large' );
							endif;
							echo '</a>';
							if ( has_post_format( 'gallery' ) ) {
								echo '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M864 260H728l-32.4-90.8a32.07 32.07 0 0 0-30.2-21.2H358.6c-13.5 0-25.6 8.5-30.1 21.2L296 260H160c-44.2 0-80 35.8-80 80v456c0 44.2 35.8 80 80 80h704c44.2 0 80-35.8 80-80V340c0-44.2-35.8-80-80-80zM512 716c-88.4 0-160-71.6-160-160s71.6-160 160-160s160 71.6 160 160s-71.6 160-160 160zm-96-160a96 96 0 1 0 192 0a96 96 0 1 0-192 0z" fill="currentColor"/></svg>';
							} elseif ( has_post_format( 'video' ) ) {
								echo '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448s448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372s372 166.6 372 372s-166.6 372-372 372z" fill="currentColor"/><path d="M719.4 499.1l-296.1-215A15.9 15.9 0 0 0 398 297v430c0 13.1 14.8 20.5 25.3 12.9l296.1-215a15.9 15.9 0 0 0 0-25.8zm-257.6 134V390.9L628.5 512L461.8 633.1z" fill="currentColor"/></svg>';
								$hrs = get_post_meta( $post->ID, '_durh', true );
								$min = get_post_meta( $post->ID, '_durm', true );
								$sec = get_post_meta( $post->ID, '_durs', true );
								if ( ! empty( $hrs ) || ! empty( $min ) || ! empty( $sec ) ) {
									echo '<div class="duration">';
									if ( ! empty( $hrs ) && 0 !== $hrs ) {
										echo esc_html( str_pad( absint( $hrs ), 2, '0', STR_PAD_LEFT ) . ':' );
									}
									if ( ! empty( $min ) ) {
										echo esc_html( str_pad( absint( $min ), 2, '0', STR_PAD_LEFT ) . ':' );
									} else {
										echo '00';
									}
									if ( ! empty( $sec ) ) {
										echo esc_html( str_pad( absint( $sec ), 2, '0', STR_PAD_LEFT ) );
									} else {
										echo '00';
									}
									echo '</div>';
								}
							}
							?>
						</div>

					<?php } ?>
					<div class="gmr-slide-title">
						<a href="<?php the_permalink(); ?>" class="gmr-slide-titlelink rp-title" title="<?php the_title(); ?>"><?php the_title(); ?></a>
					</div>
				</div>
				<?php
			endforeach;
			wp_reset_postdata();
			echo '</div>';
			echo '</div>';

		echo '</div>';
	}
endif; // endif newkarma_display_carousel.
add_action( 'newkarma_display_carousel', 'newkarma_display_carousel', 50 );

if ( ! function_exists( 'newkarma_display_modulehome' ) ) :
	/**
	 * This function for display module in homepage
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	function newkarma_display_modulehome() {
		global $post;
		$post_num = get_theme_mod( 'gmr_module_number', '3' );
		$catid    = get_theme_mod( 'gmr_category-module-home', 0 );

		$args = array(
			'post_type'              => 'post',
			'cat'                    => $catid,
			'orderby'                => 'date',
			'order'                  => 'desc',
			'showposts'              => $post_num,
			'post_status'            => 'publish',
			'ignore_sticky_posts'    => 1,
			// make it fast withour update term cache and cache results.
			// https://thomasgriffin.io/optimize-wordpress-queries/.
			'update_post_term_cache' => false,
			'update_post_meta_cache' => false,
			'no_found_rows'          => true,
		);

		$recent = get_posts( $args );
		if ( $recent ) {
			echo '<div class="clearfix gmr-modulehome">';
			echo '<div id="bigmoduleslide" class="gmr-widget-carousel gmr-big-carousel owl-carousel owl-theme">';
			foreach ( $recent as $post ) :
				setup_postdata( $post );
				$featured_image_url = wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) );
				if ( ! empty( $featured_image_url ) ) {
					echo '<div class="item gmr-slider-content">';

						echo '<div class="other-content-thumbnail">';
							echo '<a href="' . esc_url( get_permalink() ) . '" itemprop="url" title="' . the_title_attribute(
								array(
									'before' => __( 'Permalink to: ', 'newkarma' ),
									'after'  => '',
									'echo'   => false,
								)
							) . '" rel="bookmark">';
										the_post_thumbnail( 'idt-bigger-thumb' );
							echo '</a>';

					if ( has_post_format( 'gallery' ) ) {
						echo '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M864 260H728l-32.4-90.8a32.07 32.07 0 0 0-30.2-21.2H358.6c-13.5 0-25.6 8.5-30.1 21.2L296 260H160c-44.2 0-80 35.8-80 80v456c0 44.2 35.8 80 80 80h704c44.2 0 80-35.8 80-80V340c0-44.2-35.8-80-80-80zM512 716c-88.4 0-160-71.6-160-160s71.6-160 160-160s160 71.6 160 160s-71.6 160-160 160zm-96-160a96 96 0 1 0 192 0a96 96 0 1 0-192 0z" fill="currentColor"/></svg>';
					} elseif ( has_post_format( 'video' ) ) {
						echo '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448s448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372s372 166.6 372 372s-166.6 372-372 372z" fill="currentColor"/><path d="M719.4 499.1l-296.1-215A15.9 15.9 0 0 0 398 297v430c0 13.1 14.8 20.5 25.3 12.9l296.1-215a15.9 15.9 0 0 0 0-25.8zm-257.6 134V390.9L628.5 512L461.8 633.1z" fill="currentColor"/></svg>';
						$hrs = get_post_meta( $post->ID, '_durh', true );
						$min = get_post_meta( $post->ID, '_durm', true );
						$sec = get_post_meta( $post->ID, '_durs', true );
						if ( ! empty( $hrs ) || ! empty( $min ) || ! empty( $sec ) ) {
							echo '<div class="duration">';
							if ( ! empty( $hrs ) && 0 !== $hrs ) {
								echo esc_html( str_pad( absint( $hrs ), 2, '0', STR_PAD_LEFT ) . ':' );
							}
							if ( ! empty( $min ) ) {
								echo esc_html( str_pad( absint( $min ), 2, '0', STR_PAD_LEFT ) . ':' );
							} else {
								echo '00';
							}
							if ( ! empty( $sec ) ) {
								echo esc_html( str_pad( absint( $sec ), 2, '0', STR_PAD_LEFT ) );
							} else {
								echo '00';
							}
							echo '</div>';
						}
					}
						echo '</div>';

						echo '<div class="gmr-slide-title">';

					/* translators: used between list items, there is a space after the comma */
					$categories_list = get_the_category_list( esc_html__( ', ', 'newkarma' ) );
					$posted_in       = '';
					if ( $categories_list ) {
						echo '<div class="cat-links-bg">';
						echo $categories_list; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo '</div>';
					}
					?>
							<?php
							echo '<a href="' . esc_url( get_permalink() ) . '" class="rp-title" itemprop="url" title="' . the_title_attribute(
								array(
									'before' => __( 'Permalink to: ', 'newkarma' ),
									'after'  => '',
									'echo'   => false,
								)
							) . '">';
								the_title();
							echo '</a>';
							?>
							<div class="gmr-metacontent">
								<?php
								echo '<span class="posted-on">';
									echo get_the_date();
								echo '</span>';
								?>
							</div>
						</div>
					</div>
					<?php
				}
			endforeach;
			wp_reset_postdata();
			echo '</div>';
			echo '</div>';
		}
	}
endif; // endif newkarma_display_modulehome.
add_action( 'newkarma_display_modulehome', 'newkarma_display_modulehome', 50 );

if ( ! function_exists( 'newkarma_display_modulepopuler' ) ) :
	/**
	 * This function for display module populer
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	function newkarma_display_modulepopuler() {
		global $post;
		$post_num      = get_theme_mod( 'gmr_module_number', '3' );
		$cat           = get_theme_mod( 'gmr_category-module-home', 0 );
		$popular_range = get_theme_mod( 'gmr_module-populartime', 'alltime' );

		$args = array(
			'post_type'              => 'post',
			'showposts'              => $post_num,
			'post_status'            => 'publish',
			'ignore_sticky_posts'    => 1,
			// make it fast withour update term cache and cache results.
			// https://thomasgriffin.io/optimize-wordpress-queries/.
			'update_post_term_cache' => false,
			'update_post_meta_cache' => false,
			'no_found_rows'          => true,
		);

		if ( class_exists( 'Post_Views_Counter' ) ) {
			$args['orderby'] = 'post_views';
		} else {
			$args['orderby']  = 'meta_value_num';
			$args['meta_key'] = 'views'; // phpcs:ignore
			$args['order']    = 'DESC';
		}

		// Get Current Tax ID.
		$tax    = get_queried_object();
		$tax_id = $tax->term_id;

		if ( is_category() ) {
			$args['cat'] = $tax_id;
		} elseif ( is_tag() ) {
			$args['tag_id'] = $tax_id;
		} elseif ( is_tax( 'newstopic' ) ) {
			// Get posts last week.
			$args['tax_query'] = array( // phpcs:ignore
				array(
					'taxonomy' => 'newstopic',
					'field'    => 'term_id',
					'terms'    => $tax_id,
				),
			);
		}

		if ( 'weekly' === $popular_range ) {
			// Get posts last week.
			$args['date_query'] = array(
				array(
					'after' => '1 week ago',
				),
			);
		} elseif ( 'mountly' === $popular_range ) {
			// Get posts last mount.
			$args['date_query'] = array(
				array(
					'after' => '1 month ago',
				),
			);
		} elseif ( 'secondmountly' === $popular_range ) {
			// Get posts last second mount.
			$args['date_query'] = array(
				array(
					'after' => '2 months ago',
				),
			);
		} elseif ( 'yearly' === $popular_range ) {
			// Get posts last year.
			$args['date_query'] = array(
				array(
					'after' => '1 year ago',
				),
			);
		}

		$recent = get_posts( $args );
		if ( $recent ) {
			echo '<div class="clearfix gmr-modulehome">';
			echo '<div id="bigmoduleslide" class="gmr-widget-carousel gmr-big-carousel owl-carousel owl-theme">';
			foreach ( $recent as $post ) :
				setup_postdata( $post );
				$featured_image_url = wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) );
				if ( ! empty( $featured_image_url ) ) {
					echo '<div class="item gmr-slider-content">';

						echo '<div class="other-content-thumbnail">';
							echo '<a href="' . esc_url( get_permalink() ) . '" itemprop="url" title="' . the_title_attribute(
								array(
									'before' => __( 'Permalink to: ', 'newkarma' ),
									'after'  => '',
									'echo'   => false,
								)
							) . '" rel="bookmark">';
										the_post_thumbnail( 'idt-bigger-thumb' );
							echo '</a>';

					if ( has_post_format( 'gallery' ) ) {
						echo '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M864 260H728l-32.4-90.8a32.07 32.07 0 0 0-30.2-21.2H358.6c-13.5 0-25.6 8.5-30.1 21.2L296 260H160c-44.2 0-80 35.8-80 80v456c0 44.2 35.8 80 80 80h704c44.2 0 80-35.8 80-80V340c0-44.2-35.8-80-80-80zM512 716c-88.4 0-160-71.6-160-160s71.6-160 160-160s160 71.6 160 160s-71.6 160-160 160zm-96-160a96 96 0 1 0 192 0a96 96 0 1 0-192 0z" fill="currentColor"/></svg>';
					} elseif ( has_post_format( 'video' ) ) {
						echo '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024"><path d="M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448s448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372s372 166.6 372 372s-166.6 372-372 372z" fill="currentColor"/><path d="M719.4 499.1l-296.1-215A15.9 15.9 0 0 0 398 297v430c0 13.1 14.8 20.5 25.3 12.9l296.1-215a15.9 15.9 0 0 0 0-25.8zm-257.6 134V390.9L628.5 512L461.8 633.1z" fill="currentColor"/></svg>';
						$hrs = get_post_meta( $post->ID, '_durh', true );
						$min = get_post_meta( $post->ID, '_durm', true );
						$sec = get_post_meta( $post->ID, '_durs', true );
						if ( ! empty( $hrs ) || ! empty( $min ) || ! empty( $sec ) ) {
							echo '<div class="duration">';
							if ( ! empty( $hrs ) && 0 !== $hrs ) {
								echo esc_html( str_pad( absint( $hrs ), 2, '0', STR_PAD_LEFT ) . ':' );
							}
							if ( ! empty( $min ) ) {
								echo esc_html( str_pad( absint( $min ), 2, '0', STR_PAD_LEFT ) . ':' );
							} else {
								echo '00';
							}
							if ( ! empty( $sec ) ) {
								echo esc_html( str_pad( absint( $sec ), 2, '0', STR_PAD_LEFT ) );
							} else {
								echo '00';
							}
							echo '</div>';
						}
					}
						echo '</div>';

						echo '<div class="gmr-slide-title">';

					/* translators: used between list items, there is a space after the comma */
					$categories_list = get_the_category_list( esc_html__( ', ', 'newkarma' ) );
					$posted_in       = '';
					if ( $categories_list ) {
						echo '<div class="cat-links-bg">';
						echo $categories_list; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo '</div>';
					}
					?>
							<?php
							echo '<a href="' . esc_url( get_permalink() ) . '" class="rp-title" itemprop="url" title="' . the_title_attribute(
								array(
									'before' => __( 'Permalink to: ', 'newkarma' ),
									'after'  => '',
									'echo'   => false,
								)
							) . '">';
								the_title();
							echo '</a>';
							?>
							<div class="gmr-metacontent">
								<?php
								echo '<span class="posted-on">';
									echo get_the_date();
								echo '</span>';
								?>
							</div>
						</div>
					</div>
					<?php
				}
			endforeach;
			wp_reset_postdata();
			echo '</div>';
			echo '</div>';
		}
	}
endif; // endif newkarma_display_modulepopuler.
add_action( 'newkarma_display_modulepopuler', 'newkarma_display_modulepopuler', 50 );
