<?php
/**
 * Importer plugin filter.
 *
 * @link https://wordpress.org/plugins/one-click-demo-import/
 *
 * @package Newkarma
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'newkarma_ocdi_import_files' ) ) :
	/**
	 * Set one click import demo data. Plugin require is. https://wordpress.org/plugins/one-click-demo-import/
	 *
	 * @since v.1.0.0
	 * @link https://wordpress.org/plugins/one-click-demo-import/faq/
	 *
	 * @return array
	 */
	function newkarma_ocdi_import_files() {

		$arr = array(
			array(
				'import_file_name'             => 'Demo Import Newkarma',
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demo-data/demo-content.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demo-data/widgets.json',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/demo-data/customizer.dat',
				'import_notice'                => __( 'Import demo from http://demo.idtheme.com/newkarma/.', 'newkarma' ),
			),
		);
		return $arr;
	}
endif;
add_filter( 'ocdi/import_files', 'newkarma_ocdi_import_files' );

if ( ! function_exists( 'newkarma_ocdi_before_import_import' ) ) :
	/**
	 * Filter before import content. https://ocdi.com/advanced-integration-guide/
	 *
	 * @since v.1.0.0
	 * @param array $selected_import selection importer data.
	 */
	function newkarma_ocdi_before_import_import( $selected_import ) {

		// Find and delete the WP default 'Sample Page'.
		$default_page = get_page_by_title( 'Sample Page' );
		if ( ! empty( $default_page ) ) {
			wp_delete_post( $default_page->ID, $bypass_trash = true );
		}

		// Find and delete the WP default 'Hello world!' post.
		$default_post = get_posts( array( 'title' => 'Hello World!' ) );
		if ( ! empty( $default_post ) ) {
			wp_delete_post( $default_post[0]->ID, $bypass_trash = true );
		}

		/* Remove all widget active from sidebar */
		$null = null;
		update_option( 'sidebars_widgets', $null );
	}
endif;
add_action( 'ocdi/before_content_import', 'newkarma_ocdi_before_import_import' );

if ( ! function_exists( 'newkarma_ocdi_after_import' ) ) :
	/**
	 * Set action after import demo data. Plugin require is. https://wordpress.org/plugins/one-click-demo-import/
	 *
	 * @since v.1.0.0
	 * @link https://wordpress.org/plugins/one-click-demo-import/faq/
	 * @param array $selected_import selection importer data.
	 *
	 * @return void
	 */
	function newkarma_ocdi_after_import( $selected_import ) {

		if ( 'Demo Import Newkarma' === $selected_import['import_file_name'] ) {
			// Menus to Import and assign - you can remove or add as many as you want.
			$top_menu    = get_term_by( 'name', 'Top menus', 'nav_menu' );
			$second_menu = get_term_by( 'name', 'Second menus', 'nav_menu' );
			$third_menu  = get_term_by( 'name', 'Top nav', 'nav_menu' );
			$fourth_menu = get_term_by( 'name', 'Top nav', 'nav_menu' );

			set_theme_mod(
				'nav_menu_locations',
				array(
					'primary'      => $top_menu->term_id,
					'secondary'    => $second_menu->term_id,
					'topnav'       => $third_menu->term_id,
					'copyrightnav' => $fourth_menu->term_id,
				)
			);
		}

		if ( class_exists( 'Menu_Icons', false ) ) {
			$defaults = array(
				'global' => array(
					'icon_types' => array( 'image' ),
				),
			);

			update_option( 'menu-icons', $defaults );
		}

		if ( class_exists( 'Newkarma_Core_Init', false ) ) {
			$ads_options = array(
				'ads_topbanner'                 => '<img src="https://demo.idtheme.com/img/old/idt-size-72090.jpg" alt="banner 728x90" title="banner 728x90" width="728" height="90"/>',
				'ads_topbanner_aftermenu'       => '<img src="https://demo.idtheme.com/img/old/idt-size-970250.jpg" alt="banner 970x250" title="banner 970x250" width="970" height="250"/>',
				'ads_after_betweenpost'         => '<img src="https://demo.idtheme.com/img/old/idt-size-400130.jpg" alt="banner 400x130" title="banner 400x130" width="400" height="130"/>',
				'ads_before_content'            => '<img src="https://demo.idtheme.com/img/old/idt-size-46860.jpg" alt="banner 468x60" title="banner 468x60" width="468" height="60"/>',
				'ads_after_content'             => '<img src="https://demo.idtheme.com/img/old/idt-size-336280.png" alt="banner 336x280" title="banner 336x280" width="336" height="280"/>',
				'ads_inside_content'            => '<img src="https://demo.idtheme.com/img/old/idt-size-336280-2.png" alt="banner 336x280" title="banner 336x280" width="336" height="280"/>',
				'ads_before_content_attachment' => '',
				'ads_after_content_attachment'  => '',
				'ads_floatbanner_left'          => '<img src="https://demo.idtheme.com/img/old/idt-size-120600.jpg" alt="banner 120x600" title="banner 120x600" width="120" height="600"/>',
				'ads_floatbanner_right'         => '<img src="https://demo.idtheme.com/img/old/idt-size-120600-2.jpg" alt="banner 120x600" title="banner 120x600" width="120" height="600"/>',
				'ads_floatbanner_footer'        => '',
				'ads_before_dontmiss'           => '',
			);

			$ampads_options = array(
				'amp_ads_topbanner_aftermenu' => '<img src="https://demo.idtheme.com/img/old/idt-size-970250.jpg" alt="banner 970x250" title="banner 970x250" width="970" height="250"/>',
				'amp_ads_after_betweenpost'   => '<img src="https://demo.idtheme.com/img/old/idt-size-400130.jpg" alt="banner 400x130" title="banner 400x130" width="400" height="130"/>',
				'amp_ads_before_content'      => '<img src="https://demo.idtheme.com/img/old/idt-size-46860.jpg" alt="banner 468x60" title="banner 468x60" width="468" height="60"/>',
				'amp_ads_after_content'       => '<img src="https://demo.idtheme.com/img/old/idt-size-336280.png" alt="banner 336x280" title="banner 336x280" width="336" height="280"/>',
				'amp_ads_inside_content'      => '<img src="https://demo.idtheme.com/img/old/idt-size-336280-2.png" alt="banner 336x280" title="banner 336x280" width="336" height="280"/>',
				'amp_ads_before_dontmiss'     => '',
			);

			// Update entire array.
			update_option( 'newkar_ads', $ads_options );
			update_option( 'newkar_amp', $ampads_options );
		}

	}
endif;
add_action( 'ocdi/after_import', 'newkarma_ocdi_after_import' );

if ( ! function_exists( 'newkarma_change_time_of_single_ajax_call' ) ) :
	/**
	 * Change ajax call timeout
	 *
	 * @link https://github.com/awesomemotive/one-click-demo-import/blob/master/docs/import-problems.md.
	 */
	function newkarma_change_time_of_single_ajax_call() {
		return 60;
	}
endif;
add_action( 'ocdi/time_for_one_ajax_call', 'newkarma_change_time_of_single_ajax_call' );

// disable generation of smaller images (thumbnails) during the content import.
add_filter( 'ocdi/regenerate_thumbnails_in_content_import', '__return_false' );

// disable the branding notice.
add_filter( 'ocdi/disable_pt_branding', '__return_true' );
